﻿
public class Script : ScriptBase
{

    public override async Task<HttpResponseMessage> ExecuteAsync()
    {
        return await HandleForwardAndTransformOperation();
    }

    private async Task<HttpResponseMessage> HandleForwardAndTransformOperation()
    {
        // Check if the header exists and has a value; if not, set it with a new GUID
        const string headerName = "Client-Request-Id"; 
        if (!this.Context.Request.Headers.Contains(headerName) || string.IsNullOrWhiteSpace(this.Context.Request.Headers.GetValues(headerName).FirstOrDefault()))
        {
            this.Context.Request.Headers.Remove(headerName); // Remove existing empty header if any
            this.Context.Request.Headers.Add(headerName, Guid.NewGuid().ToString());
        }

        // Forward/send the HTTP request with the possibly modified header
        HttpResponseMessage response = await this.Context.SendAsync(this.Context.Request, this.CancellationToken).ConfigureAwait(false);

        if (response.IsSuccessStatusCode)
        {
            var responseString = await response.Content.ReadAsStringAsync().ConfigureAwait(false);
            var result = JObject.Parse(responseString);
            response.Content = CreateJsonContent(result.ToString());
        }

        return response;
    }

}
